/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authc.base;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.Document;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.ValidatingDocNode;
import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.codova.validation.errors.InvalidAttributeValue;
import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.searchguard.NoSuchComponentException;
import com.floragunn.searchguard.TypedComponentRegistry;
import com.floragunn.searchguard.authc.AuthenticationBackend;
import com.floragunn.searchguard.authc.AuthenticationDebugLogger;
import com.floragunn.searchguard.authc.AuthenticationDomain;
import com.floragunn.searchguard.authc.AuthenticationFrontend;
import com.floragunn.searchguard.authc.AuthenticatorUnavailableException;
import com.floragunn.searchguard.authc.CredentialsException;
import com.floragunn.searchguard.authc.RequestMetaData;
import com.floragunn.searchguard.authc.UserInformationBackend;
import com.floragunn.searchguard.authc.base.AcceptanceRules;
import com.floragunn.searchguard.authc.base.UserMapping;
import com.floragunn.searchguard.configuration.ConfigurationRepository;
import com.floragunn.searchguard.user.AuthCredentials;
import com.floragunn.searchguard.user.User;
import com.floragunn.searchsupport.cstate.ComponentState;
import com.floragunn.searchsupport.cstate.metrics.Measurement;
import com.floragunn.searchsupport.cstate.metrics.MetricsLevel;
import com.floragunn.searchsupport.cstate.metrics.TimeAggregation;
import com.google.common.hash.Hashing;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StandardAuthenticationDomain<AuthenticatorType extends AuthenticationFrontend>
implements AuthenticationDomain<AuthenticatorType>,
Comparable<StandardAuthenticationDomain<AuthenticatorType>>,
Document<StandardAuthenticationDomain<AuthenticatorType>>,
AutoCloseable {
    private static final Logger log = LogManager.getLogger(StandardAuthenticationDomain.class);
    private final DocNode source;
    private final String type;
    private final String id;
    private final AuthenticationBackend authenticationBackend;
    private final AuthenticatorType authenticationFrontend;
    private final boolean enabled;
    private final AcceptanceRules acceptanceRules;
    private final UserMapping userMapping;
    private final String description;
    private final String infoString;
    private final ImmutableList<UserInformationBackend> additionalUserInformationBackends;
    private final ComponentState componentState;
    private final MetricsLevel metricsLevel;
    private final TimeAggregation authenticationBackendMetrics = new TimeAggregation.Milliseconds();
    private final TimeAggregation userInformationBackendMetrics = new TimeAggregation.Milliseconds();
    private final TimeAggregation impersonationUserInformationBackendMetrics = new TimeAggregation.Milliseconds();
    private final int order;

    public StandardAuthenticationDomain(DocNode source, String type, String id, String description, boolean enabled, int order, AcceptanceRules acceptanceRules, AuthenticatorType authenticationFrontend, AuthenticationBackend authenticationBackend, ImmutableList<UserInformationBackend> additionalUserInformationBackends, UserMapping userMapping, MetricsLevel metricsLevel) {
        this.source = source;
        this.type = type;
        this.id = id;
        this.description = description;
        this.enabled = enabled;
        this.authenticationFrontend = authenticationFrontend;
        this.authenticationBackend = authenticationBackend;
        this.order = order;
        this.additionalUserInformationBackends = additionalUserInformationBackends;
        this.userMapping = userMapping;
        this.infoString = this.buildInfoString();
        this.acceptanceRules = acceptanceRules;
        this.componentState = new ComponentState(0, "auth_domain", this.infoString);
        this.metricsLevel = metricsLevel;
        if (authenticationFrontend != null) {
            this.componentState.addPart(authenticationFrontend.getComponentState());
        }
        if (authenticationBackend != null) {
            this.componentState.addPart(authenticationBackend.getComponentState());
        }
        this.componentState.updateStateFromParts();
        if (metricsLevel.basicEnabled()) {
            this.componentState.addMetrics("authentication_backend", (Measurement)this.authenticationBackendMetrics, "user_information_backend", (Measurement)this.userInformationBackendMetrics, "impersonation_backend", (Measurement)this.impersonationUserInformationBackendMetrics);
        }
    }

    public AuthenticationBackend getBackend() {
        return this.authenticationBackend;
    }

    @Override
    public AuthenticatorType getFrontend() {
        return this.authenticationFrontend;
    }

    public int getOrder() {
        return this.order;
    }

    @Override
    public int compareTo(StandardAuthenticationDomain<AuthenticatorType> o) {
        return Integer.compare(this.order, o.order);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public boolean accept(RequestMetaData<?> requestMetaData) {
        return this.acceptanceRules.accept(requestMetaData);
    }

    @Override
    public boolean accept(AuthCredentials authCredentials) {
        return this.acceptanceRules.accept(authCredentials);
    }

    public String toString() {
        return this.infoString;
    }

    private String buildInfoString() {
        StringBuilder result = new StringBuilder(this.type);
        if (this.id != null) {
            result.append("[").append(this.id).append("]");
        }
        return result.toString();
    }

    public static <AuthenticatorType extends AuthenticationFrontend> StandardAuthenticationDomain<AuthenticatorType> parse(DocNode documentNode, Class<AuthenticatorType> authenticatorType, ConfigurationRepository.Context context, MetricsLevel metricsLevel) throws ConfigValidationException {
        ValidationErrors validationErrors = new ValidationErrors();
        ValidatingDocNode vNode = new ValidatingDocNode(documentNode, validationErrors);
        return StandardAuthenticationDomain.parse(vNode, validationErrors, authenticatorType, context, metricsLevel);
    }

    public static <AuthenticatorType extends AuthenticationFrontend> StandardAuthenticationDomain<AuthenticatorType> parse(ValidatingDocNode vNode, ValidationErrors validationErrors, Class<AuthenticatorType> authenticatorType, ConfigurationRepository.Context context, MetricsLevel metricsLevel) throws ConfigValidationException {
        TypedComponentRegistry typedComponentRegistry = context.modulesRegistry().getTypedComponentRegistry();
        String id = vNode.get("id").asString();
        String description = vNode.get("description").asString();
        boolean enabled = vNode.get("enabled").withDefault(true).asBoolean();
        int order = vNode.get("order").withDefault((Number)0).asInt();
        AcceptanceRules acceptanceRules = new AcceptanceRules((AcceptanceRules.Criteria)vNode.get("accept").by(AcceptanceRules.Criteria::parse), (AcceptanceRules.Criteria)vNode.get("skip").by(AcceptanceRules.Criteria::parse));
        UserMapping userMapping = (UserMapping)vNode.get("user_mapping").by(UserMapping::parse);
        String type = vNode.get("type").required().asString();
        AuthenticationFrontend authenticator = null;
        AuthenticationBackend authenticationBackend = AuthenticationBackend.NOOP;
        ImmutableList<UserInformationBackend> additionalUserInformationBackends = ImmutableList.empty();
        if (type != null) {
            String backendType;
            String authenticatorSubType;
            int slash = type.indexOf(47);
            if (slash == -1) {
                authenticatorSubType = type;
                backendType = null;
            } else {
                authenticatorSubType = type.substring(0, slash);
                backendType = type.substring(slash + 1);
            }
            try {
                authenticator = (AuthenticationFrontend)typedComponentRegistry.create(authenticatorType, authenticatorSubType, vNode.getDocumentNode().getAsNode(authenticatorSubType), context);
            }
            catch (ConfigValidationException e) {
                validationErrors.add(authenticatorSubType, e);
            }
            catch (NoSuchComponentException e) {
                validationErrors.add(new InvalidAttributeValue("type", (Object)type, (Object)e.getAvailableTypesAsInfoString()).message("Unknown authentication frontend").cause((Throwable)e));
            }
            if (backendType != null) {
                try {
                    authenticationBackend = typedComponentRegistry.create(AuthenticationBackend.class, backendType, vNode.getDocumentNode().getAsNode(backendType), context);
                }
                catch (ConfigValidationException e) {
                    validationErrors.add(backendType, e);
                }
                catch (NoSuchComponentException e) {
                    validationErrors.add(new InvalidAttributeValue("type", (Object)type, (Object)e.getAvailableTypesAsInfoString()).message("Unknown authentication backend").cause((Throwable)e));
                }
            }
        }
        if (id == null) {
            id = Hashing.sha256().hashString((CharSequence)vNode.getDocumentNode().toJsonString(), StandardCharsets.UTF_8).toString().substring(0, 8);
        }
        if (vNode.hasNonNull("additional_user_information")) {
            try {
                additionalUserInformationBackends = StandardAuthenticationDomain.parseAdditionalUserInformationBackends((List<DocNode>)vNode.getDocumentNode().getAsListOfNodes("additional_user_information"), context);
            }
            catch (ConfigValidationException e) {
                validationErrors.add("additional_user_information", e);
            }
        }
        validationErrors.throwExceptionForPresentErrors();
        return new StandardAuthenticationDomain<AuthenticationFrontend>(vNode.getDocumentNode(), type, id, description, enabled, order, acceptanceRules, authenticator, authenticationBackend, additionalUserInformationBackends, userMapping, metricsLevel);
    }

    private static ImmutableList<UserInformationBackend> parseAdditionalUserInformationBackends(List<DocNode> list, ConfigurationRepository.Context context) throws ConfigValidationException {
        ValidationErrors validationErrors = new ValidationErrors();
        ImmutableList.Builder result = new ImmutableList.Builder(list.size());
        for (int i = 0; i < list.size(); ++i) {
            try {
                result.with((Object)StandardAuthenticationDomain.parseAdditionalUserInformationBackend(list.get(i), context));
                continue;
            }
            catch (ConfigValidationException e) {
                validationErrors.add(String.valueOf(i), e);
            }
        }
        validationErrors.throwExceptionForPresentErrors();
        return result.build();
    }

    private static UserInformationBackend parseAdditionalUserInformationBackend(DocNode docNode, ConfigurationRepository.Context context) throws ConfigValidationException {
        ValidationErrors validationErrors = new ValidationErrors();
        ValidatingDocNode vNode = new ValidatingDocNode(docNode, validationErrors);
        String type = ((ValidatingDocNode.Attribute)vNode.get("type").required().expected(context.modulesRegistry().getTypedComponentRegistry().getAvailableSubTypesAsShortString(UserInformationBackend.class))).asString();
        validationErrors.throwExceptionForPresentErrors();
        try {
            return context.modulesRegistry().getTypedComponentRegistry().create(UserInformationBackend.class, type, docNode.getAsNode(type), context);
        }
        catch (ConfigValidationException e) {
            validationErrors.add(type, e);
        }
        catch (NoSuchComponentException e) {
            validationErrors.add(new InvalidAttributeValue("type", (Object)type, e.getAvailableTypes()).message("Unknown authentication backend").cause((Throwable)e));
        }
        throw new ConfigValidationException(validationErrors);
    }

    public UserMapping getUserMapping() {
        return this.userMapping;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public AuthenticationBackend.UserMapper getUserMapper() {
        if (this.userMapping != null) {
            return this.userMapping;
        }
        return AuthenticationBackend.UserMapper.DIRECT;
    }

    @Override
    public AuthenticationDomain.CredentialsMapper getCredentialsMapper() {
        if (this.userMapping != null) {
            return this.userMapping;
        }
        return AuthenticationDomain.CredentialsMapper.DIRECT;
    }

    public ImmutableList<UserInformationBackend> getAdditionalUserInformationBackends() {
        return this.additionalUserInformationBackends;
    }

    /*
     * Exception decompiling
     */
    @Override
    public CompletableFuture<User> authenticate(AuthCredentials authCredentials, AuthenticationDebugLogger debug) throws AuthenticatorUnavailableException, CredentialsException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundSuperForBase(org.benf.cfr.reader.bytecode.analysis.types.JavaTypeInstance)" because "bindingSuperContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.LoopLivenessClash.getIterableIterType(LoopLivenessClash.java:35)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.LoopLivenessClash.detect(LoopLivenessClash.java:66)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.LoopLivenessClash.detect(LoopLivenessClash.java:25)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:827)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public CompletableFuture<User> impersonate(User originalUser, AuthCredentials authCredentials) throws AuthenticatorUnavailableException, CredentialsException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundSuperForBase(org.benf.cfr.reader.bytecode.analysis.types.JavaTypeInstance)" because "bindingSuperContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.LoopLivenessClash.getIterableIterType(LoopLivenessClash.java:35)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.LoopLivenessClash.detect(LoopLivenessClash.java:66)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.LoopLivenessClash.detect(LoopLivenessClash.java:25)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:827)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public String getType() {
        return this.type;
    }

    public Object toBasicObject() {
        return this.source;
    }

    @Override
    public boolean cacheUser() {
        switch (this.authenticationBackend.userCachingPolicy()) {
            case ALWAYS: {
                return true;
            }
            case ONLY_IF_AUTHZ_SEPARATE: {
                return !this.additionalUserInformationBackends.isEmpty();
            }
        }
        return false;
    }

    public String getDescription() {
        return this.description;
    }

    public ComponentState getComponentState() {
        return this.componentState;
    }

    @Override
    public void close() {
        try {
            if (this.authenticationBackend instanceof AutoCloseable) {
                ((AutoCloseable)((Object)this.authenticationBackend)).close();
            }
        }
        catch (Exception e) {
            log.error("Error while closing " + this.authenticationBackend, (Throwable)e);
        }
        try {
            if (this.authenticationFrontend instanceof AutoCloseable) {
                ((AutoCloseable)this.authenticationFrontend).close();
            }
        }
        catch (Exception e) {
            log.error("Error while closing " + this.authenticationFrontend, (Throwable)e);
        }
        if (this.additionalUserInformationBackends != null) {
            for (UserInformationBackend userInformationBackend : this.additionalUserInformationBackends) {
                try {
                    if (!(userInformationBackend instanceof AutoCloseable)) continue;
                    ((AutoCloseable)((Object)userInformationBackend)).close();
                }
                catch (Exception e) {
                    log.error("Error while closing " + userInformationBackend, (Throwable)e);
                }
            }
        }
    }
}

